using System;
using System.Reflection;
using System.Resources;
using System.Collections.Generic;
using System.Text;

namespace AssemblyDemo1
{
   class Program
   {
      static void Main(string[] args)
      {
         Assembly a = Assembly.GetExecutingAssembly();
         Console.WriteLine("Biecy zestaw '{0}' zosta zaadowany z '{1}'",
            a.GetName().Name, a.Location);
         Console.WriteLine("\nWczytany z globalnego bufora zestaww (GAC)? {0}",
           a.GlobalAssemblyCache ? "Tak" : "Nie");
         Console.WriteLine(
            "Zestaw ten wymaga co najmniej wersji Framework {0} (wersja kompilacji zestawu)",
            a.ImageRuntimeVersion);

         Console.WriteLine("Punkt startu zestawu {0}.", a.EntryPoint.ToString());

         Console.WriteLine("Typy zawarte w tym zestawie:");
         foreach (Type t in a.GetTypes())
         {
            Console.WriteLine("\t'{0}'  zawarty w '{1}'",
               t.Name, t.Assembly.GetName().Name);
         }

         Console.ReadLine();
      }
   }
}
